% [pocetKomp,velikost,cleny] = networkComponents_vzdal(ukaz,nasl,vzdal)
 
% VSTUPY:
% ukaz                    vektor. Vektor ukazatel, kter na pozici i udvaj,
%                         kde ve vektoru nasledovnk zanaj uzly sousedc s  
%                         uzlem i. 
% nasl                    vektor. Vektor nsledovnk.
% vzdal                   vektor. Vektor vzdlenost, pokud obsahuje
%                         nekoneno, znamen to, e tato hrana je neprjezdn.
%
% VSTUPY:
% pocetKomp             INT - Poet komponent v sti.
% velikost              vektor - vektor obsahujc velikost jednotlivch 
%                               komponent, setdn sestupn.
% cleny               pole bunk - pole vektor; kad pozice obsahuje vektor
%                                  len, nlecch do jedn komponenty. 
%                                  Setdn podle velikosti komponent.
%



function [pocetKomp,velikost,cleny] = networkComponents_vzdal(ukaz,nasl,vzdal)
N = length(ukaz)-1;    % poet uzl
isDiscovered = zeros(N,1);  % Je u uzel navtven?
cleny = {};   % Przdn pole len
novyNbrs=[];  %przdn vektor nov nalezench soused
% Projdeme kad uzel
for n=1:N
     if ~isDiscovered(n)
        cleny{end+1} = n; % zalome novou buku komponenty a pidme prvnho lena
        isDiscovered(n) = 1;  % uzel ozname za navtven
        p = 1;  % pomocnou promnnou nastavme na 1
        while (p <= length(cleny{end})) 
            %projdeme sousedy uzlu
           for k=(ukaz(cleny{end}(p))):((ukaz((cleny{end}(p))+1))-1)
             if isDiscovered(nasl(k))==0  %vybereme prozatm nenavtven sousedy
                 if vzdal(1,k)<inf  %vybereme sousedy s konenou vzdlenost
                        novyNbrs(end+1) = nasl(k);
                  end
             end
           end
            isDiscovered(novyNbrs) = 1; % nyn u je ozname za navtven
            cleny{end}(end+1:end+length(novyNbrs)) = novyNbrs; % zaadme je do vektoru len
            p = p+1;  % navme hodnotu pomocn promnn, abychom mohli provit dal uzel komponenty
            novyNbrs=[];
        end
     end
 end
% poet komponent
 pocetKomp = length(cleny);
 for n=1:pocetKomp
     % spotme velikost komponenty
     velikost(n) = length(cleny{n});
 end
%seazen
[velikost,id] = sort(velikost,'descend');
cleny = cleny(id);
% % velikost nejvt komponenty
% velikonstNK = velikost(1);
end